function [z, seriesSum, A, B, C, D, values, Yscaled] = Basic_Syntax_Solutions(x, y, X, Y)
%% Question 1
L = length(x);
index = (1:L)';

z = ((-1).^index).* ...
    (x.^3 + cos(y))./ ...
    (1 + (x.*y).*sqrt(1 + log(x)));


%% Question 2
%Solution #1:
n = 1:2:9999;
seriesSum = sum(1./n - 1./(n+1));

%Solution #2 (slightly more cumbersome):
n = 1:10000;
signTerm = ones(1, length(n));
signTerm(2:2:end) = -1; %Create an array: [ 1, -1,  1, -1,  1, ...]
seriesSum = dot(signTerm, 1./n);

%A third solution would be the same as Solution #2 but instead of using the
%dot function, simply store 1./n in a vector, e.g., v = 1./n and do:
%   seriesSum = signTerm*v';  or  seriesSum = v*signTerm';


%% Question 3
[M, ~] = size(X);

%Solution to i)
A = X(1:2:end, 1:2:end);

%Solution to ii)
B = X(2:end-1, 2:end-1);

%Solution(s) to iii)
%Those who are inquisitive enough will find out that there is a built-in
%MATLAB function that can fetch any diagonal of a matrix.
C = [diag(X, 1)'; diag(X, -1)'];

% However, linear indexing can also do the job.
CUpper = X(2:(M+1):end);
CLower = X((M+1):(M+1):end);
C = [CUpper; CLower];


%% Question 4
load('data.mat')

plot(t, V)
title('Capacitor Voltage', 'FontSize', 18)
xlabel('time (ms)', 'FontSize', 18)
ylabel('voltage (V)', 'FontSize', 18)
set(gca, 'FontSize', 14)
set(gca, 'XLim', [0 max(t)])


%% Question 5
load('data.mat')
t_i = [0.45, 2.003, 7];

values = getValues(V, t, t_i);


%% Question 6
[M, N, P] = size(Y);

w = 10:10:10*P;
w = reshape(w, 1, 1, P);
W = repmat(w, [M N 1]);
Yscaled = Y.*W;

%% Question 7
load('student_grades.mat')

for ii = 1:length(StudentGrades)
    units = StudentGrades(ii).grades{:,2};
    grades = StudentGrades(ii).grades{:,3};
    cgpa = sum(units.*grades)/sum(units);
    
    StudentGrades(ii).cgpa = cgpa;
end

end

